/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.base;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.base.logging.Logger;
import filenet.vw.integrator.IVWAdaptorControl;
import filenet.vw.integrator.adaptors.webservices.VWWebServicesAdaptor;
import filenet.vw.integrator.base.VWAdaptor;
import filenet.vw.integrator.base.VWResources;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class VWAdaptorControl
extends UnicastRemoteObject
implements IVWAdaptorControl {
    private static final long serialVersionUID = 7449L;
    protected Date lastStartTime = null;
    protected Date lastStopTime = null;
    protected Vector adaptors = null;
    protected VWQueue queue = null;
    protected String component_descriptor = null;
    protected VWXMLWrapper component_descriptor_doc = null;
    protected static Logger logger = Logger.getLogger("filenet.vw.ComponentIntegrator");
    protected String m_className = "VWAdaptorControl:";
    protected boolean is_web_services = false;

    public static String _get_FILE_DATE() {
        return "$Date:   21 Jan 2008 22:28:26  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.25  $";
    }

    public VWAdaptorControl(VWQueue queue, String component_descriptor) throws RemoteException {
        String m_method = "<init>";
        this.m_className = this.m_className + queue.toString();
        logger.entering(this.m_className, "<init>");
        if (logger.isFinest()) {
            logger.finest(this.m_className, "<init>", "queue: " + queue + "comp. desc=" + component_descriptor);
        }
        try {
            this.queue = queue;
            this.component_descriptor = component_descriptor;
            this.component_descriptor_doc = new VWXMLWrapper(component_descriptor);
            String adaptor_class_name = VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "adaptor_class");
            this.is_web_services = adaptor_class_name.indexOf("filenet.vw.integrator.adaptors.webservices.VWWebServicesAdaptor") != -1;
        }
        catch (Exception e) {
            logger.throwing(this.m_className, "<init>", e);
            throw new RemoteException("VWAdaptorControl::<init>", e);
        }
        finally {
            logger.exiting(this.m_className, "<init>");
        }
    }

    Vector getAdaptors() {
        return this.adaptors;
    }

    public String getName() throws RemoteException {
        return VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "name");
    }

    public String getComponentDescriptor() throws RemoteException {
        return this.component_descriptor;
    }

    public void setComponentDescriptor(String component_descriptor) throws RemoteException {
        String m_method = "setComponentDescriptor";
        logger.entering(this.m_className, "setComponentDescriptor");
        if (logger.isFinest()) {
            logger.finest(this.m_className, "setComponentDescriptor", "component descriptor:  " + component_descriptor);
        }
        try {
            this.component_descriptor = component_descriptor;
            this.component_descriptor_doc = new VWXMLWrapper(component_descriptor);
            if (this.is_web_services) {
                VWWebServicesAdaptor.PersistComponentDescriptor(component_descriptor);
            }
        }
        catch (Exception e) {
            logger.throwing(this.m_className, "setComponentDescriptor", e);
            throw new RemoteException("VWAdaptorControl::setComponentDescriptor", e);
        }
        finally {
            logger.exiting(this.m_className, "setComponentDescriptor");
        }
    }

    public Date getLastStartTime() throws RemoteException {
        return this.lastStartTime;
    }

    public Date getLastStopTime() throws RemoteException {
        return this.lastStopTime;
    }

    public long getAverageCallsPerMinute() throws RemoteException {
        String m_method = "getAverageCallsPerMinute";
        long callsPerMinute = 0L;
        try {
            if (this.adaptors != null) {
                Enumeration elements = this.adaptors.elements();
                while (elements.hasMoreElements()) {
                    VWAdaptor adaptor = (VWAdaptor)elements.nextElement();
                    callsPerMinute += adaptor.getAverageCallsPerMinute();
                }
            }
            long elements = callsPerMinute;
            return elements;
        }
        catch (Exception e) {
            logger.throwing(this.m_className, "getAverageCallsPerMinute", e);
            throw new RemoteException("VWAdaptorControl::getAverageCallsPerMinute", e);
        }
    }

    public long getAverageCallTimeMillis() throws RemoteException {
        String m_method = "getAverageCallTimeMillis";
        long result = 0L;
        try {
            long callTimeMillis = 0L;
            if (this.adaptors != null && this.adaptors.size() > 0) {
                Enumeration elements = this.adaptors.elements();
                while (elements.hasMoreElements()) {
                    VWAdaptor adaptor = (VWAdaptor)elements.nextElement();
                    callTimeMillis += adaptor.getAverageCallTimeMillis();
                }
                result = callTimeMillis / (long)this.adaptors.size();
            }
            long l = result;
            return l;
        }
        catch (Exception e) {
            logger.throwing(this.m_className, "getAverageCallTimeMillis", e);
            throw new RemoteException("VWAdaptorControl::getAverageCallTimeMillis", e);
        }
    }

    public void resetCallTimeStatistics() throws RemoteException {
        String m_method = "resetCallTimeStatistics";
        try {
            if (this.adaptors != null) {
                Enumeration elements = this.adaptors.elements();
                while (elements.hasMoreElements()) {
                    VWAdaptor adaptor = (VWAdaptor)elements.nextElement();
                    adaptor.resetCallTimeStatistics();
                }
            }
        }
        catch (Exception e) {
            logger.throwing(this.m_className, "resetCallTimeStatistics", e);
            throw new RemoteException("VWAdaptorControl::resetCallTimeStatistics", e);
        }
    }

    public boolean adaptorIsStarted() throws RemoteException {
        boolean isStarted = false;
        if (this.adaptors != null) {
            Enumeration elements = this.adaptors.elements();
            while (elements.hasMoreElements()) {
                VWAdaptor adaptor = (VWAdaptor)elements.nextElement();
                if (!adaptor.isRunning()) continue;
                isStarted = true;
            }
        }
        return isStarted;
    }

    public String status() throws RemoteException {
        try {
            if (this.adaptors != null) {
                StringBuffer buf = new StringBuffer();
                Enumeration elements = this.adaptors.elements();
                while (elements.hasMoreElements()) {
                    VWAdaptor adaptor = (VWAdaptor)elements.nextElement();
                    buf.append(adaptor.toString()).append("\n");
                }
                return buf.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return VWResources.S_ADAPTORCONTROL_NOADAPTORS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerEvent() throws RemoteException {
        if (this.adaptors != null && this.adaptors.size() > 0) {
            Enumeration elements = this.adaptors.elements();
            while (elements.hasMoreElements()) {
                VWAdaptor adaptor;
                VWAdaptor vWAdaptor = adaptor = (VWAdaptor)elements.nextElement();
                synchronized (vWAdaptor) {
                    adaptor.notifyAll();
                }
            }
        }
    }

    public void start() throws RemoteException {
        String m_method = "start";
        logger.entering(this.m_className, "start");
        try {
            VWAdaptor adaptor;
            if (this.adaptors != null) {
                Enumeration elements = this.adaptors.elements();
                while (elements.hasMoreElements()) {
                    VWAdaptor adaptor2 = (VWAdaptor)elements.nextElement();
                    adaptor2.stop();
                }
                this.adaptors.removeAllElements();
                this.adaptors = null;
            }
            VWSession session = this.queue.getServiceSession();
            String username = VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "jaas_username");
            String[] qnames = new String[]{this.queue.toString()};
            try {
                session.recoverUser(username, qnames);
            }
            catch (Exception e) {
                logger.throwing(this.m_className, "start", e);
            }
            String ct = VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "concurrent_threads");
            int concurrent_threads = Integer.parseInt(ct);
            this.adaptors = new Vector();
            if (concurrent_threads > 0) {
                for (int i = 1; i <= concurrent_threads; ++i) {
                    adaptor = null;
                    adaptor = this.is_web_services ? new VWWebServicesAdaptor(this.queue, this.component_descriptor, i) : new VWAdaptor(this.queue, this.component_descriptor, i);
                    this.adaptors.add(adaptor);
                }
            }
            Enumeration elements = this.adaptors.elements();
            while (elements.hasMoreElements()) {
                adaptor = (VWAdaptor)elements.nextElement();
                Thread t = new Thread((Runnable)adaptor, adaptor.toString());
                t.start();
            }
            this.lastStartTime = new Date();
        }
        catch (Exception e) {
            if (this.adaptors != null) {
                Enumeration elements = this.adaptors.elements();
                while (elements.hasMoreElements()) {
                    VWAdaptor adaptor = (VWAdaptor)elements.nextElement();
                    adaptor.stop();
                }
                this.adaptors.removeAllElements();
                this.adaptors = null;
            }
            logger.throwing(this.m_className, "start", e);
            throw new RemoteException("VWAdaptorControl::start", e);
        }
        logger.exiting(this.m_className, "start");
    }

    public void stop() throws RemoteException {
        String m_method = "stop";
        logger.entering(this.m_className, "stop");
        try {
            if (this.adaptors != null) {
                Enumeration elements = this.adaptors.elements();
                while (elements.hasMoreElements()) {
                    VWAdaptor adaptor = (VWAdaptor)elements.nextElement();
                    adaptor.stop();
                }
                this.triggerEvent();
                this.adaptors.removeAllElements();
                this.adaptors = null;
            }
            this.lastStopTime = new Date();
        }
        catch (Exception e) {
            logger.throwing(this.m_className, "stop", e);
            throw new RemoteException("VWAdaptorControl::stop", e);
        }
        logger.exiting(this.m_className, "stop");
    }

    public void refresh() throws RemoteException {
        if (this.is_web_services) {
            return;
        }
        String m_method = "refresh";
        logger.entering(this.m_className, "refresh");
        try {
            this.stop();
            this.component_descriptor_doc = null;
            VWQueueDefinition qdef = null;
            VWAttributeInfo attributes = null;
            if (this.queue != null) {
                qdef = this.queue.fetchQueueDefinition();
            }
            if (qdef != null) {
                attributes = qdef.getAttributeInfo();
            }
            if (attributes != null) {
                this.component_descriptor = (String)attributes.getFieldValue("F_ComponentDescriptor");
            }
            if (this.component_descriptor != null) {
                this.component_descriptor_doc = new VWXMLWrapper(this.component_descriptor);
            }
            if (this.component_descriptor_doc == null) {
                throw new RemoteException("VWAdaptorControl::refresh", new VWException("VWAdaptorControl.CouldNotRefreshDesc", "Failed to refresh component descriptor."));
            }
            this.start();
        }
        catch (Exception e) {
            logger.throwing(this.m_className, "refresh", e);
            throw new RemoteException("VWAdaptorControl::refresh", e);
        }
        logger.exiting(this.m_className, "refresh");
    }

    public VWQueue getQueue() {
        return this.queue;
    }

    public String toString() {
        return "VWAdaptorControl: queue=" + this.queue.toString() + ", desc=" + this.component_descriptor;
    }
}

